<?php
/*
Plugin Name: XPRSS - Search by Stock Number
Description: Stock number search filter add-on for the RV SHOWROOM
Version: 2.25.218
Author: Vlad Xprss
*/
// Function to handle the search query with custom meta field 'stock-number'
function custom_search_filter($query) {
    $post_type = isset($_GET['post_type']) ? $_GET['post_type'] : '';
    // Check if it's the desired post type
    if ($post_type == 'rv-products') {
        // Check if the custom search parameter is set
        if (isset($_GET['custom_search']) && !empty($_GET['custom_search'])) {
            // Modify the query to include the custom meta field 'stock-number' search
            $meta_query = array(
                array(
                    'key'     => 'stock-number', // Replace with your actual meta key
                    'value'   => sanitize_text_field($_GET['custom_search']),
                    'compare' => 'LIKE',
                ),
            );
            $query->query_vars['meta_query'] = $meta_query;
        }
    }
}
// Function to display the custom search box
function custom_post_type_filter() {
    global $post_type;
    // Specify the post types to add the search box to
    $post_types = array('rv-products');
    // Check if the current post type is in the array
    if (in_array($post_type, $post_types)) {
        // Output your custom search box HTML
        ?>
        <input type="text" name="custom_search" placeholder="Stock number" value="<?php echo isset($_GET['custom_search']) ? esc_attr($_GET['custom_search']) : ''; ?>" />
        <?php
    }
}
// Hook to apply the custom search filter
add_filter('parse_query', 'custom_search_filter');
// Hook to add the custom search box with priority 5 to appear before bulk actions
add_action('restrict_manage_posts', 'custom_post_type_filter', 5);