<?php
/******************************************************************************************
 * Copyright (C) Smackcoders. - All Rights Reserved under Smackcoders Proprietary License
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * You can contact Smackcoders at email address info@smackcoders.com.
 *******************************************************************************************/
namespace Smackcoders\WCSV;

if ( ! defined( 'ABSPATH' ) )
exit; // Exit if accessed directly

class ImageSchedule {
    private static $instance=null;
    public static $media_instance = null;
    public static $corefields_instance = null;

    public static function getInstance() {
        if ( null == self::$instance ) {
            self::$instance = new self;
            self::$media_instance = MediaHandling::getInstance();
            self::$corefields_instance = CoreFieldsImport::getInstance();

        }
        return self::$instance;
	}
    
    public function __construct() {
		$this->plugin = Plugin::getInstance();	
    }

    /**
     * schedule_array parameter gets values as templatekey or hash_key.
     * unikey represents the name like templatekey / hash_key string.
     */
    public function image_schedule($schedule_array,$unikey)
    {                
        global $wpdb;
        $get_result = $wpdb->get_results("SELECT  post_id FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE status = 'pending' ORDER BY post_id ASC LIMIT 5", ARRAY_A);        
        //$get_result = $wpdb->get_results("SELECT post_id FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager as a join {$wpdb->prefix}posts as b on a.post_id = b.ID WHERE a.status = 'pending' AND b.ID != 'trash' ORDER BY a.post_id ASC LIMIT 10", ARRAY_A);
        
        if(empty($get_result)){
            $schedule_argument = array($schedule_array,$unikey);
            wp_clear_scheduled_hook('smackcsv_image_schedule_hook', $schedule_argument);
        }
        else{            
            $records = array_column($get_result, 'post_id');  
           
            foreach ($records as $title => $id) {                         
                $get_shortcode = $wpdb->get_var("SELECT image_shortcode FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND $unikey = '$schedule_array' AND status = 'pending' ");
                $get_image_meta = $wpdb->get_var("SELECT image_meta FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND $unikey = '$schedule_array' AND status = 'pending' ");
                $get_import_type = $wpdb->get_var("SELECT import_type FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND $unikey = '$schedule_array' AND status = 'pending' ");                      
                if(empty($get_import_type)){
                    $get_import_type = 'post';
                }
                
                if($get_shortcode == 'featured_image'){
                    $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND status = 'pending' ");
                    $post_values['featured_image'] = $get_original_image;
                    $image_type = 'Featured';
    
                    $attach_id = self::$media_instance->media_handling( $get_original_image , $id ,$post_values,'','', $schedule_array);                                        
                    if($attach_id){
                        
                        $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
                        $this->update_success_count_table( $image_type ,$schedule_array,$unikey);
                    }
                    else{
                        
                        $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                        $this->update_failure_count_table( $image_type ,$schedule_array,$unikey);

                        $this->update_db_values($id, '_thumbnail_id', '', $get_import_type);
                        //update_post_meta($id, '_thumbnail_id', '');
                    }
                }
                elseif($get_shortcode == 'inline'){               
                    $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND status = 'pending' ");
                    $post_values['inline'] = $get_original_image;
                    $image_type = 'inline';
                    $attach_id = self::$media_instance->media_handling( $get_original_image , $id ,$post_values,'','','');                    
                    $core_instance = CoreFieldsImport::getInstance();
                    $core_instance->image_handling($id);
                   
                     if($attach_id){                        
                         $this->update_status_shortcode_table($id, $get_shortcode, 'completed');                     
                         $this->update_success_count_table($image_type ,$schedule_array,$unikey);
                     }
                     else{                        
                         $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                         $this->update_failure_count_table($image_type ,$schedule_array,$unikey);
                     }
                }
                elseif( strpos($get_shortcode, 'yoast_opengraph_image__') !== false) {
                    $image_type = 'yoast_opengraph';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);             
                }
                elseif( strpos($get_shortcode, 'yoast_twitter_image__') !== false) {
                    $image_type = 'yoast_twitter';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);             
                }
                elseif( strpos($get_shortcode, 'wpmember_image__') !== false) {
                    $image_type = 'wpmember';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);             
                }  
                elseif( strpos($get_shortcode, 'term_image__') !== false) {
                    $image_type = 'term';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);             
                }  
                elseif( strpos($get_shortcode, 'cmb2_image__') !== false) {
                    $image_type = 'cmb2';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);             
                }  
                elseif( strpos($get_shortcode, 'cfs_image__') !== false) {
                    $image_type = 'cfs';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'metabox_image__') !== false) {
                    $image_type = 'metabox';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'metabox_clone_image__') !== false) {
                    $image_type = 'metabox_clone';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'metabox_image_clone_image__') !== false) {
                    $image_type = 'metabox_image_clone';                    
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'metabox_advanced_image__') !== false) {
                    $image_type = 'metabox_advanced';
                    $this->images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey);
                }
                 elseif(strpos($get_shortcode, 'metabox_custom_image__') !== false) {
                    $image_type ='metabox_custom';
                    $this->metabox_custom_image($id,$get_shortcode,$schedule_array,$image_type,$get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'wordpress_custom_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, '', 'wordpress_custom_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_image__') !== false) {
                    $image_type = 'acf';
                    $this->acf_image_update($id,$image_type, $get_shortcode, $get_image_meta, 'acf_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_group_image__') !== false) {
                    $image_type = 'acf_group';
                    $this->acf_image_update($id,$image_type, $get_shortcode, $get_image_meta, 'acf_group_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_repeater_image__') !== false) {
                    $image_type = 'acf_repeater';
                    $this->acf_image_update($id,$image_type ,$get_shortcode, $get_image_meta, 'acf_repeater_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_flexible_image__') !== false) {
                    $image_type = 'acf_flexible';
                    $this->acf_image_update($id,$image_type ,$get_shortcode, $get_image_meta, 'acf_flexible_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_group_repeater_image__') !== false) {
                    $image_type = 'acf_group_repeater';
                    $this->acf_image_update($id,$image_type, $get_shortcode, $get_image_meta, 'acf_group_repeater_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_repeater_group_image__') !== false) {
                    $image_type = 'acf_repeater_group';
                    $this->acf_image_update($id,$image_type, $get_shortcode, $get_image_meta, 'acf_repeater_group_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_group_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_group_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_repeater_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_repeater_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_group_repeater_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_group_repeater_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_repeater_group_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_repeater_group_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'acf_flexible_gallery_image__') !== false) {
                    $this->acf_gallery_image_update($id, $get_shortcode, $get_image_meta, 'acf_flexible_gallery_image__', $get_import_type,$unikey);
                }
                elseif( strpos($get_shortcode, 'pods_image__') !== false ){
                    $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND status = 'pending' ");
                    $get_image_fieldname = explode('__', $get_shortcode); 
                    $image_type = 'pods';
                    // $attach_id = self::$media_instance->media_handling( $get_original_image, $id, $get_image_fieldname[1]);
					$attach_id = self::$media_instance->media_handling( $get_original_image, $id, array());
					
                    if($attach_id){
                        //update_post_meta($id, $get_image_fieldname[1], $attach_id);
                        $this->update_db_values($id, $get_image_fieldname[1], $attach_id, $get_import_type);

                        if(!empty($get_image_meta)){
                            $image_meta = unserialize($get_image_meta);
                            self::$media_instance->acfimageMetaImports($attach_id, $image_meta, 'pods');
                        }

                        $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
                        $this->update_success_count_table($image_type,$schedule_array,$unikey);
                    }
                    else{
                        $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                        $this->update_failure_count_table($image_type,$schedule_array,$unikey);

                        //update_post_meta($id, $get_image_fieldname[1], '');
                        $this->update_db_values($id, $get_image_fieldname[1], '', $get_import_type);

                    }
                }

                elseif( strpos($get_shortcode, 'product_image__') !== false ){
                    $get_gallery_images = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE 'product_image__%' AND post_id = $id AND status = 'pending' ");
                    $get_image_fieldname = explode('__', $get_shortcode); 
                    $image_gallery = '';
                    $gallery_ids = [];
                    $image_type = 'product';
        
                    foreach($get_gallery_images as $gallery_key => $gallery_image){
                        $gallery_image_url = $gallery_image->original_image;
                   
                        $image_metas = [];
                        if(!empty($get_image_meta)){
                            $image_metas = unserialize($get_image_meta);
                            if(!empty($image_metas['product_file_name'][$gallery_key])){
                                $image_metas = $image_metas['product_file_name'][$gallery_key];
                            }
                        }
                        // $attach_id = self::$media_instance->media_handling( $gallery_image_url, $id, $get_image_fieldname[1]);
                        $attach_id = self::$media_instance->media_handling( $gallery_image_url, $id, array(), null, null, null, null, null, null, $image_metas);
                        if($attach_id){ 
                         
                            $image_gallery .= $attach_id . ',';
                            $gallery_ids[] = $attach_id;
                            $this->update_success_count_table($image_type,$schedule_array,$unikey);
                        }
                        else{
                            $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                            $this->update_failure_count_table($image_type,$schedule_array,$unikey);

                            //update_post_meta($id, $get_image_fieldname[1], '');
                            $this->update_db_values($id, $get_image_fieldname[1], '', $get_import_type);
                        }
                    } 
                       

                    if(!empty($image_gallery)){
                        $productImageGallery = substr($image_gallery, 0, -1);
                        //update_post_meta($id, '_'.$get_image_fieldname[1], $productImageGallery);
                        $this->update_db_values($id, '_'.$get_image_fieldname[1], $productImageGallery, $get_import_type);

                        if(!empty($get_image_meta)){
                            $image_meta = unserialize($get_image_meta);
                            //self::$media_instance->acfgalleryMetaImports($gallery_ids,$image_meta, 'product');	
                            self::$media_instance->acfImageMetaImports($gallery_ids,$image_meta, 'product');	
                        }
        
                        $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
                       
                    }
                }

                elseif( strpos($get_shortcode, 'types_image__') !== false ){
                    $get_original_image = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE 'types_image__%' AND post_id = $id AND status = 'pending' ",ARRAY_A);
                    $get_image_fieldname = explode('__', $get_shortcode); 
                    $gallery_ids = [];
                    $image_type = 'types';
                    foreach($get_original_image as $gallery_image){
                        // $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id, $get_image_fieldname[1]);
                        $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id);

                        if($attach_id){
                            $gallery_ids[] = $attach_id;
                        }
                        else{
                            $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                            $this->update_failure_count_table($image_type,$schedule_array,$unikey);
                        }
                    }

                    if($gallery_ids){
                        // delete dummy imagemeta
                        delete_post_meta($id, $get_image_fieldname[1]);
                        foreach($gallery_ids as $gallery_id){
                            $get_guid = $wpdb->get_var("SELECT guid FROM {$wpdb->prefix}posts WHERE ID = $gallery_id");
                            add_post_meta($id, $get_image_fieldname[1], $get_guid);
                        }
                    }

                    if(!empty($get_image_meta)){
                        $image_meta = unserialize($get_image_meta);
                        self::$media_instance->acfimageMetaImports($gallery_ids, $image_meta, 'types');
                    }

                    if($gallery_ids){
                        $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
                        $this->update_success_count_table($image_type,$schedule_array,$unikey);
                    }
                }   
                elseif(strpos($get_shortcode, 'jetengine_media_') !== false ){
                    $this->jetengine_image_update($id, $get_shortcode, $get_image_meta, 'jetengine_media_', $get_import_type,$schedule_array,$unikey);
                } 
                elseif(strpos($get_shortcode, 'jetengine_gallery_') !== false ){
                    $this->jetengine_image_update($id, $get_shortcode, $get_image_meta, 'jetengine_gallery_', $get_import_type,$schedule_array,$unikey);
                }  
                elseif(strpos($get_shortcode, 'jetengine_repeater_media_') !== false ){
                     $this->jetengine_image_update($id, $get_shortcode, $get_image_meta, 'jetengine_repeater_media_', $get_import_type,$schedule_array,$unikey);
                 }      
                 elseif(strpos($get_shortcode,'jetengine_repeater_gallery_') !==false){
                     $this->jetengine_image_update($id, $get_shortcode, $get_image_meta, 'jetengine_repeater_gallery_',$get_import_type,$schedule_array,$unikey);
                 }         
                else{
                    $core_instance = CoreFieldsImport::getInstance();
                    $post_id = $core_instance->image_handling($id);
                }
            }   
        }
    }

    public function delete_image_schedule(){
        global $wpdb;
        // $wpdb->get_results("DELETE FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager");
        $wpdb->get_results("DELETE FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE status = 'completed' ");

        $check_for_pending_images = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE status = 'pending' ");
        if(empty($check_for_pending_images)){
            $check_for_loading_images = $wpdb->get_results("SELECT ID FROM {$wpdb->prefix}posts WHERE guid LIKE '%loading-image%' ");
            if(!empty($check_for_loading_images)){
                $delete_post_id = $check_for_loading_images[0]->ID;
                $wpdb->get_results("DELETE FROM {$wpdb->prefix}posts WHERE ID = $delete_post_id ");
                $wpdb->get_results("DELETE FROM {$wpdb->prefix}postmeta WHERE post_id = $delete_post_id ");
            }
        }
    }

    public function update_status_shortcode_table($id, $get_shortcode, $status,$get_origin_image=null){
        global $wpdb;
        if($get_origin_image !=null){
            $wpdb->update( $wpdb->prefix . 'ultimate_csv_importer_shortcode_manager' , 
            array( 
                'status' => $status,
            ) , 
            array( 'post_id' => $id ,
                'image_shortcode' => $get_shortcode,
                'original_image' => $get_origin_image
            ) 
        );
        }
        else{
            $wpdb->update( $wpdb->prefix . 'ultimate_csv_importer_shortcode_manager' , 
            array( 
                'status' => $status,
            ) , 
            array( 'post_id' => $id ,
                'image_shortcode' => $get_shortcode,
            ) 
        ); 
        }
        
    }

    public function update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, $status){
        global $wpdb;
        $wpdb->update( $wpdb->prefix . 'ultimate_csv_importer_shortcode_manager' , 
            array( 
                'status' => $status,
            ) , 
            array( 'post_id' => $id ,
                'image_shortcode' => $get_shortcode,
                'original_image' => $get_origin_image,
            ) 
        );
    }

    public function update_success_count_table($image_type,$schedule_array,$unikey){
        global $wpdb; 
        
        $image_media_table = $wpdb->prefix . 'ultimate_csv_importer_media_report';
        $get_success_count = $wpdb->get_var("SELECT success_count FROM $image_media_table WHERE $unikey = '$schedule_array' AND image_type ='$image_type' ");
        $get_add = $get_success_count + 1;
                
        $result = $wpdb->update( $image_media_table , 
            array( 
                'success_count' => $get_add,
            ), 
            array( $unikey => $schedule_array ,
                    'image_type' => $image_type
                        
            ) 
        );                
    }

    public function update_failure_count_table($image_type,$schedule_array,$unikey){        
        global $wpdb;
        $image_media_table = $wpdb->prefix . 'ultimate_csv_importer_media_report';
        $get_fail_count = $wpdb->get_var("SELECT fail_count FROM $image_media_table WHERE $unikey = '$schedule_array' AND image_type ='$image_type' ");
        $get_add = $get_fail_count + 1;

        $wpdb->update( $image_media_table , 
            array( 
                'fail_count' => $get_add,
            ), 
            array( $unikey => $schedule_array ,
                    'image_type' => $image_type             
            ) 
        );
    }

    public function acf_image_update($id, $image_type,$get_shortcode, $get_image_meta, $image_shortcode, $get_import_type,$unikey){        
        global $wpdb;             
        $get_image_fieldname = explode('__', $get_shortcode); 
        if($image_shortcode == 'acf_group_repeater_image__' || $image_shortcode == 'acf_repeater_group_image__' ){
            $shortcode = $get_image_fieldname[1];
            $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '%$shortcode' AND post_id = $id ");
        }
        else{           
            $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '$get_shortcode' AND post_id = $id ");
        }

        $acf_key = $wpdb->get_var("SELECT $unikey FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id  ");         
        $attach_id = self::$media_instance->media_handling( $get_original_image, $id);       
       
        if($attach_id){
           // update_post_meta($id, $get_image_fieldname[1], $attach_id);
            $this->update_db_values($id, $get_image_fieldname[1], $attach_id, $get_import_type);

            if(!empty($get_image_meta)){
                $image_meta = unserialize($get_image_meta);
                self::$media_instance->acfimageMetaImports($attach_id, $image_meta, 'acf');
            }
            $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
            $this->update_success_count_table($image_type,$acf_key,$unikey);

        }
        else{
            $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
            $this->update_failure_count_table($image_type,$acf_key,$unikey);

            //update_post_meta($id, $get_image_fieldname[1], '');
            $this->update_db_values($id, $get_image_fieldname[1], '', $get_import_type);
        }   
    }

    public function acf_gallery_image_update($id, $get_shortcode, $get_image_meta, $image_shortcode, $get_import_type,$unikey){
        global $wpdb;
        $get_image_fieldname = explode('__', $get_shortcode);
        if($image_shortcode == 'acf_repeater_gallery_image__' || $image_shortcode == 'acf_group_repeater_gallery_image__' || $image_shortcode == 'acf_repeater_group_gallery_image__' ){
            $shortcode = $get_image_fieldname[1];
            $get_gallery_images = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '%$shortcode' AND post_id = $id ", ARRAY_A);  
        }
        else{
            $shortcode = $get_image_fieldname[1];
            $get_gallery_images = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '%$shortcode' AND post_id = $id ", ARRAY_A);
        }
        $acf_key = $wpdb->get_var("SELECT $unikey FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id  ");
        $image_type = chop($image_shortcode,'_image__');
        $image_media_table = $wpdb->prefix . 'ultimate_csv_importer_media_report';
        
        $gallery_ids = [];
        $get_existing_gallery_ids = get_post_meta($id, $get_image_fieldname[1]);
        if(!empty($get_existing_gallery_ids[0]) && is_array($get_existing_gallery_ids[0])){
            $gallery_ids = $get_existing_gallery_ids[0];
        }
    
        foreach($get_gallery_images as $gallery_image){
            $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id);

            if($attach_id){ 
                $gallery_ids[] = $attach_id;
                $get_origin_image = $gallery_image['original_image'];
                $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'completed');
            }
            else{
                $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
                $this->update_failure_count_table($image_type,$acf_key,$unikey);
            }
        } 
      
        if(!empty($gallery_ids)){
            if( strpos($get_shortcode, 'wordpress_custom_image__') !== false) {
               // update_post_meta($id, 'image_gallery_ids', $imgs);
                $this->update_db_values($id, 'image_gallery_ids', $imgs, $get_import_type);
            }
            else{
                //update_post_meta($id, $get_image_fieldname[1], $gallery_ids);
                $this->update_db_values($id, $get_image_fieldname[1], $gallery_ids, $get_import_type);
            }
            if(!empty($get_image_meta)){
                $image_meta = unserialize($get_image_meta);
                self::$media_instance->acfgalleryMetaImports($gallery_ids,$image_meta, 'acf');	
            }
            // $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
            foreach($gallery_ids as $gallery_id){
                $this->update_success_count_table($image_type,$acf_key,$unikey);
            }
        }    
    }

    public function jetengine_image_update($id, $get_shortcode, $get_image_meta, $image_shortcode, $get_import_type,$schedule_array,$unikey){
        global $wpdb;
        $get_image_fieldname = explode('__', $get_shortcode); 
        $shortcode = end($get_image_fieldname);        
        $get_original_image = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '%$shortcode' AND post_id = $id AND status = 'pending' ",ARRAY_A);        
        $image_meta = json_decode($get_image_meta);        
        $header_array = $image_meta->headerarray;
        $value_array = $image_meta->valuearray;
        $tablename = $image_meta->tablename;  
        $imgformat = $image_meta->returnformat;       
        
        if($image_shortcode == 'jetengine_media_'){
            $image_type = 'jetengine_media';
            foreach($get_original_image as $gallery_image){
                $get_origin_image =$gallery_image['original_image'];
                $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id, '', '', '', $schedule_array,$header_array,$value_array);                                
                if($attach_id){       
                    switch($imgformat){
                        case 'url' :
                            {
                                $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
								$dir = wp_upload_dir();
								$imagedata = $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;
                                break;
                            }
                        case 'both' :
                            {
                                $img_d1 ['id']= $attach_id;									
								$img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
								$dir = wp_upload_dir();
								$img_d2['url']= $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;									
								$imagedata = array_merge($img_d1,$img_d2);	                                
                                break;
                            }
                        default :
                        {
                            $imagedata = $attach_id;
                            break;
                        }
                        
                    }
                    
                    if($get_import_type == 'post' || $get_import_type == 'term' || $get_import_type == 'user'|| $get_import_type == 'comments'){
                     $this->update_db_values($id, $get_image_fieldname[1], $imagedata, $get_import_type);
                    }
                    else{    
                        $table_name = $wpdb->prefix.'jet_cct_'.$tablename;                                                                  
                     $fieldname=$get_image_fieldname[1];
                     $result =$wpdb->update($table_name,
                         array( 
                             $fieldname => $imagedata,
                         ) , 
                         array( '_ID' => $id)); 
                    }
                     $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'completed');
                     $this->update_success_count_table($image_type,$schedule_array,$unikey);
                 }
                 else{
                     $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'failed');
                     $this->update_failure_count_table($image_type,$schedule_array,$unikey);
                 }
             }
         }
         if($image_shortcode == 'jetengine_gallery_'){
            $imagedata_both = $imagedata = $gallery_ids = array();
             
             $image_type = 'jetengine_gallery';
             foreach($get_original_image as $gallery_image){
                 $get_origin_image = $gallery_image['original_image'];
                 $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id, '', '', '', '',$header_array,$value_array);
                 if($attach_id){
                     $gallery_ids[]= $attach_id;
                     $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'Completed');
                     $this->update_success_count_table($image_type,$schedule_array,$unikey);
                 }
                 else{
                     $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'failed');
                     $this->update_failure_count_table($image_type,$schedule_array,$unikey);
                 }
             }
             if(!empty($gallery_ids)){
                foreach($gallery_ids as $imgid){
                switch($imgformat){                    
                    case 'url' :
                        {
                            $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$imgid and meta_key ='_wp_attached_file'");
                            $dir = wp_upload_dir();
                            $imagedata[] = $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;
                            break;
                        }
                    case 'both' :
                        {                               
                            $img_d1 ['id']= $imgid;									
                            $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$imgid and meta_key ='_wp_attached_file'");
                            $dir = wp_upload_dir();
                            $img_d2['url']= $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;									
                            $imagedata_both[] = array_merge($img_d1,$img_d2);	                                                            
                            break;
                        }
                    default :
                    {
                        $imagedata[] = $imgid;
                        break;
                    }
                }
                    
                }
                if(!empty($imagedata_both)){
                    $image_details = $imagedata_both;
                }
                else{
                    $image_details = implode(',',$imagedata);
                }
                
                 if($get_import_type == 'post' || $get_import_type == 'term' || $get_import_type == 'user'|| $get_import_type == 'comments'){
                     $this->update_db_values($id, $get_image_fieldname[1], $image_details, $get_import_type);
                 }
                 else{
                    $table_name = $wpdb->prefix.'jet_cct_'.$tablename;                                          
                     $fieldname=$get_image_fieldname[1];
                     $result =$wpdb->update($table_name,
                     array( 
                         $fieldname => $image_details,
                     ) , 
                     array( '_ID' => $id)); 
                 }
             }
         }
         else if($image_shortcode == 'jetengine_repeater_media_'){
              $image_type = 'jetengine_repeater_media';
              $rep = explode('__',$get_shortcode);    
              $imagedata = "";
              foreach($get_original_image as $gallery_image){
                  $get_origin_image = $gallery_image['original_image'];                  
                  $shortcode_rep = $wpdb->get_var("SELECT image_shortcode FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE original_image ='$get_origin_image' AND post_id = $id AND status = 'pending' ");
                  $rep = explode('__',$shortcode_rep);                  
                  $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id, '', '', '', '',$header_array,$value_array);			                  
                  if($attach_id){
                    switch($imgformat){
                        case 'url' :
                            {
                                $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
								$dir = wp_upload_dir();
								$imagedata = $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;
                                break;
                            }
                        case 'both' :
                            {
                                $img_d1 ['id']= $attach_id;									
								$img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
								$dir = wp_upload_dir();
								$img_d2['url']= $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;									
								$imagedata = array_merge($img_d1,$img_d2);	                                
                                break;
                            }
                        default :
                        {
                            $imagedata = $attach_id;
                            break;
                        }
                        
                    }                
                      $get_value = array();
                      //$get_value gets the field information
                      if($get_import_type == 'post' || $get_import_type == 'user'|| $get_import_type == 'comments'){
                         $get_value = get_post_meta($id,$rep[2]);
                         if(isset($get_value[0]))
                            $get_value = $get_value[0];
                      }
                      else if($get_import_type == 'term'){
                        $get_value = get_term_meta($id,$rep[2]);
                        if(isset($get_value[0]))
                            $get_value = $get_value[0];
                      }
                      else if($get_import_type == 'postcct' ||$get_import_type == 'termcct' || $get_import_type == 'usercct' ||$get_import_type == 'commentcct'){                                                                        
                         $fieldname=$rep[2];
                         $table_name = $wpdb->prefix.'jet_cct_'.$tablename;                         
                         $get_value = $wpdb->get_var("SELECT $fieldname FROM $table_name WHERE _ID=$id");                       
                      }
                      if(is_serialized($get_value)){
                        $get_value = unserialize($get_value);
                    }                        
                      
                      //Process the field values(replace original image id)
                      foreach($get_value as $gkey => $gval){
                            if($gkey == $rep[1]) {
                          foreach($gval as $gk => $gv){
                              if($shortcode == $gk){
                                if($get_import_type == 'post' || $get_import_type == 'term' || $get_import_type == 'user'|| $get_import_type == 'comments'){ 
                                    $get_value[$gkey][$gk] = $imagedata;    
                                }
                                else 
                                    $get_value[$gkey][$gk] = $attach_id;                                    
                              }                           
                          }
                        }
                          
                      }                     
                      //Store the data into DB                     
                     if($get_import_type == 'post' || $get_import_type == 'term' || $get_import_type == 'user'|| $get_import_type == 'comments'){ 
                         $this->update_db_values($id, $rep[2], $get_value, $get_import_type);
                     }
                     else{    
                        if(!empty($get_value))
                            $get_value = serialize($get_value);                     
                         $table_name = $wpdb->prefix.'jet_cct_'.$tablename;                                          
                     $fieldname=$rep[2];
                     $result =$wpdb->update($table_name,
                     array( 
                         $fieldname => $get_value,
                     ) , 
                     array( '_ID' => $id)); 
                     }                     
                      $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'Completed');
                      $this->update_success_count_table($image_type,$schedule_array,$unikey);
                  }
                  else{
                      $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'failed');
                      $this->update_failure_count_table($image_type,$schedule_array,$unikey);
                  }
              }
          }
          elseif($image_shortcode == 'jetengine_repeater_gallery_'){              
              $image_type = 'jetengine_repeater_gallery';              
              $gallery_arr = array();    
              $imagedata_both = $imagedata = $get_value =array();       
              
              foreach($get_original_image as $gallery_image){
                  $get_origin_image = $gallery_image['original_image'];                  
                  $shortcode_rep = $wpdb->get_var("SELECT image_shortcode FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE original_image ='$get_origin_image' AND post_id = $id AND status = 'pending' ");
                  $rep = explode('__',$shortcode_rep);
                  $attach_id = self::$media_instance->media_handling( $gallery_image['original_image'], $id, '', '', '', '',$header_array,$value_array);			
                  if($attach_id){                                      
                    switch($imgformat){
                       case 'url' :
                           {
                               $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
                               $dir = wp_upload_dir();
                               $imagedata[$rep[1]][] = $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;
                               break;
                           }
                       case 'both' :
                           {
                               $img_d1 ['id']= $attach_id;									
                               $img_metaurl = $wpdb->get_results("select meta_value from {$wpdb->prefix}postmeta where post_id=$attach_id and meta_key ='_wp_attached_file'");
                               $dir = wp_upload_dir();
                               $img_d2['url']= $dir ['baseurl'] . '/' .$img_metaurl[0]->meta_value;									
                               $imagedata_both[$rep[1]][] = array_merge($img_d1,$img_d2);	                                
                               break;
                           }
                       default :
                       {
                           $imagedata[$rep[1]][] = $attach_id;
                           break;
                       }
                       
                   }       
               
               if(!empty($imagedata_both[$rep[1]])){
                   $image_details[$rep[1]] = $imagedata_both[$rep[1]];
               }
               else{
                   $image_details[$rep[1]] = implode(',',$imagedata[$rep[1]]);
               }                                           
                      $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'Completed');
                      $this->update_success_count_table($image_type,$schedule_array,$unikey);
                  }
                  else{
                      $this->update_status_shortcode_table_jet($id, $get_shortcode,$get_origin_image, 'failed');
                      $this->update_failure_count_table($image_type,$schedule_array,$unikey);
                  }                  
             }                         
             
             if(!empty($image_details[$rep[1]])){
                                  
                    if($get_import_type == 'post' || $get_import_type == 'user'|| $get_import_type == 'comments'){
                        $get_value = get_post_meta($id,$rep[2]);
                        if(isset($get_value[0]))
                            $get_value = $get_value[0];
                    }
                    elseif($get_import_type == 'term'){
                        $get_value = get_term_meta($id,$rep[2]);
                        if(isset($get_value[0]))
                            $get_value = $get_value[0];
                    }
                    else if($get_import_type == 'postcct' ||$get_import_type == 'termcct' || $get_import_type == 'usercct' ||$get_import_type == 'commentcct'){                                                
                        $tablename = $wpdb->prefix . 'jet_cct_' . $tablename;                        
                        $fieldname=$rep[2];
                        $get_value = $wpdb->get_var("SELECT $fieldname FROM $tablename WHERE _ID=$id");
                    }
                    if(is_serialized($get_value))
                        $get_value = unserialize($get_value);                   

                    foreach($get_value as $gkey => $gval){
                        foreach($gval as $gk => $gv){                           
                            if(array_key_exists($gkey,$image_details) && $shortcode == $gk){                                                               
                               $get_value[$gkey][$gk] = $image_details[$gkey];                               
                            }                           
                        }
                     
                    }
                                   
                    if($get_import_type == 'post' || $get_import_type == 'term' || $get_import_type == 'user'|| $get_import_type == 'comments'){ 
                        $this->update_db_values($id, $rep[2], $get_value, $get_import_type);
                    }
                    else{                                   
                        $fieldname=$rep[2];

                    if(!empty($get_value))
                        $get_value = serialize($get_value);
                        $result =$wpdb->update($tablename,
                        array( 
                            $fieldname => $get_value,
                        ) , 
                        array( '_ID' => $id));                         
                    }                 
            }
        }
    }

    public function images_import_function($id, $get_shortcode, $schedule_array, $image_type, $get_import_type,$unikey){
        global $wpdb;        
        $get_original_image = $wpdb->get_var("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND status = 'pending' ");
        $get_image_fieldname = explode('__', $get_shortcode); 
        $attach_id = self::$media_instance->media_handling( $get_original_image, $id, array());
    
        if($attach_id){
            if($image_type == 'wpmember'){
                update_user_meta($id, $get_image_fieldname[1], $attach_id);
            }
            elseif($image_type == 'cfs'){
                //update_post_meta($id, $get_image_fieldname[1], $attach_id);
                $this->update_db_values($id, $get_image_fieldname[1], $attach_id, $get_import_type);
            }
            elseif($image_type == 'term'){
                update_term_meta($id, $get_image_fieldname[1], $attach_id);
            }
            elseif($image_type == 'metabox' || $image_type == 'metabox_clone' || $image_type == 'metabox_image_clone'){
                $this->update_db_values($id, $get_image_fieldname[1], $attach_id, $get_import_type);
            }
            elseif($image_type = 'metabox_advanced'){
                add_post_meta($id, $get_image_fieldname[1], $attach_id);	
            }

            $this->update_status_shortcode_table($id, $get_shortcode, 'completed',$get_original_image);
            $this->update_success_count_table($image_type,$schedule_array,$unikey);
        }
        else{
            $this->update_status_shortcode_table($id, $get_shortcode, 'failed',$get_original_image);
            $this->update_failure_count_table($image_type,$schedule_array,$unikey);
        }
    }
    public function metabox_custom_image($id,$get_shortcode,$schedule_array,$image_type,$get_import_type,$unikey){
        global $wpdb;
        $get_image_fieldname = explode('__', $get_shortcode); 
        $shortcode = $get_image_fieldname[1];
        $get_original_image = $wpdb->get_results("SELECT original_image FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE image_shortcode LIKE '%$shortcode' AND post_id = $id AND status = 'pending' ",ARRAY_A);
        $get_image_fieldname = explode('__', $get_shortcode);
        $image_id =array(); 
        $get_table = $wpdb->get_results("SELECT image_meta FROM {$wpdb->prefix}ultimate_csv_importer_shortcode_manager WHERE post_id = $id AND status = 'pending'",ARRAY_A);
        foreach($get_table as $table){
          $table_name = unserialize($table['image_meta']);
        }
        foreach($get_original_image as $gallery_image){
          $get_origin_image = $gallery_image['original_image'];
          $attach_id = self::$media_instance->media_handling( $get_origin_image, $id, array());
          if(!empty($attach_id)){
              $image_id [] = $attach_id;
              $this->update_status_shortcode_table($id, $get_shortcode, 'completed');
              $this->update_success_count_table($image_type,$schedule_array,$unikey);
          }
          else{
              $this->update_status_shortcode_table($id, $get_shortcode, 'failed');
              $this->update_failure_count_table($image_type,$schedule_array,$unikey);
          }
        }
        $image_key =$get_image_fieldname[1];
        $image_id =serialize($image_id);
        $wpdb->update($table_name,
        array($image_key => $image_id),
        array("ID" => $id));
    }

    public function update_db_values($post_id, $meta_key, $meta_value, $import_type){
        global $wpdb;
        if($import_type == 'post'){
            update_post_meta($post_id, $meta_key, $meta_value);
        }
        elseif($import_type == 'term'){
            update_term_meta($post_id, $meta_key, $meta_value);
        }
        elseif($import_type == 'user'){
            update_user_meta($post_id, $meta_key, $meta_value);
        }
    }
}